<?php

namespace App\Controller;

use App\Entity\BookingTable;
use App\Form\BookingTableType;
use App\Repository\BookingTableRepository;
use Doctrine\ORM\EntityManagerInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Attribute\Route;

#[Route('/booking/table')]
final class BookingTableController extends AbstractController
{
    #[Route(name: 'app_booking_table_index', methods: ['GET'])]
    public function index(BookingTableRepository $bookingTableRepository): Response
    {
        return $this->render('booking_table/index.html.twig', [
            'booking_tables' => $bookingTableRepository->findAll(),
        ]);
    }

    #[Route('/new', name: 'app_booking_table_new', methods: ['GET', 'POST'])]
    public function new(Request $request, EntityManagerInterface $entityManager): Response
    {
        $bookingTable = new BookingTable();
        $form = $this->createForm(BookingTableType::class, $bookingTable);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $bookingTable->setConfermato(false);
            $entityManager->persist($bookingTable);
            $entityManager->flush();

            return $this->render('booking_table/confirm.html.twig');
        }

        return $this->render('booking_table/new.html.twig', [
            'booking_table' => $bookingTable,
            'form' => $form,
        ]);
    }

    #[Route('/confirm', name: 'app_confirm', methods: ['GET'])]
    public function confirm(): Response
    {
        return $this->render('booking_table/confirm.html.twig');
    }

    #[Route('/{id}', name: 'app_booking_table_show', methods: ['GET'])]
    public function show(BookingTable $bookingTable): Response
    {
        return $this->render('booking_table/show.html.twig', [
            'booking_table' => $bookingTable,
        ]);
    }

    #[Route('/{id}/edit', name: 'app_booking_table_edit', methods: ['GET', 'POST'])]
    public function edit(Request $request, BookingTable $bookingTable, EntityManagerInterface $entityManager): Response
    {
        $form = $this->createForm(BookingTableType::class, $bookingTable);
        $form->handleRequest($request);

        if ($form->isSubmitted() && $form->isValid()) {
            $entityManager->flush();

            return $this->redirectToRoute('app_booking_table_index', [], Response::HTTP_SEE_OTHER);
        }

        return $this->render('booking_table/edit.html.twig', [
            'booking_table' => $bookingTable,
            'form' => $form,
        ]);
    }

    #[Route('/{id}', name: 'app_booking_table_delete', methods: ['POST'])]
    public function delete(Request $request, BookingTable $bookingTable, EntityManagerInterface $entityManager): Response
    {
        if ($this->isCsrfTokenValid('delete'.$bookingTable->getId(), $request->getPayload()->getString('_token'))) {
            $entityManager->remove($bookingTable);
            $entityManager->flush();
        }

        return $this->redirectToRoute('app_booking_table_index', [], Response::HTTP_SEE_OTHER);
    }
}
